﻿
using Hims.Api.Models;
using Hims.Api.Utilities;
using Hims.Domain.Helpers;
using Hims.Domain.Services;
using Hims.Infrastructure.Services;
using Hims.Shared.DataFilters;
using Hims.Shared.EntityModels;
using Hims.Shared.Library.Enums;
using Hims.Shared.UserModels;
using Hims.Shared.UserModels.PediatricEncounter;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace Hims.Api.Controllers
{

    /// <inheritdoc />
    [Authorize]
    [Route("api/denver-charts")]
    [Consumes("application/json")]
    [Produces("application/json")]
    public class DenverChartController : BaseController
    {
        /// <summary>
        /// The idproof services.
        /// </summary>
        private readonly IDenverChartService denverChartService;
        private readonly IAESHelper aesHelper;



        /// <inheritdoc />
        public DenverChartController(IDenverChartService denverChartService, IAESHelper aesHelper)
        {
            this.denverChartService = denverChartService;
            this.aesHelper = aesHelper;

        }

        /// <summary>
        /// Inserts the hoc asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <param name="location">The location.</param>
        /// <returns></returns>
        [HttpPost]
        [Route("add")]
        public async Task<ActionResult> InsertAsync([FromBody] DenverChartModel model, [FromHeader] LocationHeader header)
        {
            model = (DenverChartModel)EmptyFilter.Handler(model);
            if (!string.IsNullOrEmpty(model.EncryptedAppointmentId))
            {
                model.AppointmentId = Convert.ToInt32(this.aesHelper.Decode(model.EncryptedAppointmentId));
            }
            var response = await this.denverChartService.InsertAsync(model);

            return this.Success(response);
        }



        /// <summary>
        /// Fetches all asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <param name="location">The location.</param>
        /// <returns></returns>
        [HttpPost]
        [Route("fetch")]
        public async Task<ActionResult> FetchAsync([FromBody] DenverChartModel model)
        {
            model = (DenverChartModel)EmptyFilter.Handler(model);
            var response = await this.denverChartService.FetchAllAsync(model);
            return this.Success(response);
        }

        [HttpPost]
        [Route("fetchbyid")]
        public async Task<ActionResult> FetchbyIdAsync([FromBody] DenverChartModel model)
        {
            model = (DenverChartModel)EmptyFilter.Handler(model);
            if (!string.IsNullOrEmpty(model.EncryptedAppointmentId))
            {
                model.AppointmentId = Convert.ToInt32(this.aesHelper.Decode(model.EncryptedAppointmentId));
            }

            var response = await this.denverChartService.FetchByAppointmentIdAsync(model);
            if (response != null)
            {
                //response.EncryptedAppointmentId = this.aesHelper.Encode(appointmentId.ToString());
            }
            return this.Success(response);
        }


    }
}


